// MainHook.cpp : Defines the entry point for the DLL application.
//


#include "stdafx.h"
#include "MainHook.h"
#include "WINUSER.H"    //contains all these constants, structs, etc...
						//WINABLE.H more info on hooks



//-------------------------
// Global Variables
//-------------------------
HANDLE	hInstance;				// Global instance handle for	DLL
HHOOK	hhookHooks;				// Hook handle


//-------------------------
// Shared DATA
//-------------------------
#pragma data_seg("SHARDATA")
#pragma data_seg()



//-------------------------
// DLL Code
//-------------------------
BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	hInstance = hModule;

	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}



//-------------------------------
// This is an exported function.
//-------------------------------
MAINHOOK_API int InstallFilterDLL()
{
	//It seems that the hhookHooks handle is different for every process.
	//  Therefore placing this var in the SHARDATA section will gpf or lock up
	//  the system because there is only 1 hhookHooks handle.

	hhookHooks = SetWindowsHookEx(WH_CALLWNDPROC,(HOOKPROC) CallWndProc, (HINSTANCE) hInstance, 0);
}


MAINHOOK_API int UnInstallFilterDLL(void)
{
	UnhookWindowsHookEx(hhookHooks);
	return 1;
}










//---------------------------------------------------------------------------
//
// Filter function for the WH_CALLWNDPROC
//
//---------------------------------------------------------------------------
LRESULT WINAPI CallWndProc(int nCode, WPARAM wParam, LPARAM lParam) 
{ 
	CWPSTRUCT	*lpMsg;
	
	if (nCode >= 0)
	{
		lpMsg = (CWPSTRUCT *) lParam;
    
		switch (nCode)     
		{
			case HC_ACTION: 
				break;  
			default:
				break;
		}
	}

	//Pass all messages on to the next hook in the chain
	return CallNextHookEx(hhookHooks, nCode, wParam, lParam); 
} 

